	IF EXISTS (SELECT * FROM sys.objects 
						WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_TRANSF_PARAM_EST_ARV_MERC_CATEGORIA]') 
						AND type in (N'U')) 
	BEGIN 
		DROP TABLE [dbo].[EST_PROD_TRANSF_PARAM_EST_ARV_MERC_CATEGORIA]
	END

	SET ANSI_NULLS ON 
	SET QUOTED_IDENTIFIER ON 
	SET ANSI_PADDING ON 

	CREATE TABLE [dbo].[EST_PROD_TRANSF_PARAM_EST_ARV_MERC_CATEGORIA](

		[CD_EMP] [int] NOT NULL CONSTRAINT [DF_EST_PROD_TRANSF_PARAM_EST_ARV_MERC_CATEGORIA_CD_EMP] DEFAULT ((0)),
		[CD_FILIAL_DEPOSITO] [int] NOT NULL CONSTRAINT [DF_EST_PROD_TRANSF_PARAM_EST_ARV_MERC_CATEGORIA_CD_FILIAL_DEPOSITO] DEFAULT ((0)),
		[CD_ARV_MERC_CATEG] [int] NOT NULL CONSTRAINT [DF_EST_PROD_TRANSF_PARAM_EST_ARV_MERC_CATEGORIA_CD_ARV_MERC_CATEG] DEFAULT ((0)),
		[DT_RESSUP] [datetime] NOT NULL,
		[PERC_AUMENTO] [money] NOT NULL CONSTRAINT [DF_EST_PROD_TRANSF_PARAM_EST_ARV_MERC_CATEGORIA_PERC_AUMENTO] DEFAULT ((0)),
		[CD_USU] [int] NOT NULL CONSTRAINT [DF_EST_PROD_TRANSF_PARAM_EST_ARV_MERC_CATEGORIA_CD_USU]  DEFAULT ((0)),
		[DT_CAD] [datetime] NOT NULL,
		[DT_ULT_ALT] [datetime] NULL,
 
	 CONSTRAINT [PK_EST_PROD_TRANSF_PARAM_EST_ARV_MERC_CATEGORIA] PRIMARY KEY CLUSTERED 
	(
		[DT_RESSUP] DESC,
		[CD_FILIAL_DEPOSITO] ASC,
		[CD_ARV_MERC_CATEG] ASC,
		[CD_EMP] ASC
 
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_PROD_TRANSF_PARAM_EST_ARV_MERC_CATEGORIA]  
		WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TRANSF_PARAM_EST_ARV_MERC_CATEGORIA] FOREIGN KEY(CD_EMP, CD_ARV_MERC_CATEG)
	REFERENCES [dbo].[EST_ARV_MERC_CATEGORIA] (CD_EMP, CD_ARV_MERC_CATEG)
	ON UPDATE CASCADE
	ON DELETE CASCADE 
	 